# This file is part of xrayutilities.
#
# xrayutilities is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Copyright (C) 2012 Dominik Kriegner <dominik.kriegner@gmail.com>

import os.path
from itertools import permutations

import matplotlib as mpl
import matplotlib.pyplot as plt
import numpy
import xrayutilities as xu
from mpl_toolkits.basemap import *

plt.close("all") # remove all old open plot windows

datadir = "./"

eps = 0.01
# plot settings
mpl.rcParams['font.size'] = 18.0
mpl.rcParams['axes.labelsize'] = 'large'
mpl.rcParams['legend.fancybox'] = True
mpl.rcParams['legend.handletextpad'] = 0.5
mpl.rcParams['legend.fontsize'] = 'medium'
mpl.rcParams['figure.subplot.bottom'] = 0.13
mpl.rcParams['figure.subplot.top'] = 0.93
mpl.rcParams['figure.subplot.left'] = 0.14
mpl.rcParams['figure.subplot.right'] = 0.915
mpl.rcParams['savefig.dpi'] = 300
mpl.rcParams['axes.grid'] = False

# substrate
GaP = xu.materials.GaP

hkls = list(permutations([1, 1, 1])) + list(permutations([-1, 1, 1])) +\
       list(permutations([-1, -1, 1])) + list(permutations([1, 1, -1])) +\
       list(permutations([-1, 1, -1])) + list(permutations([-1, -1, -1]))

tup = []
label = []
for ind in hkls:
    tup.append(GaP.Q(*ind))
    lab = r'$('
    for index in ind:
        lab += '%s' % (r'\bar' if index < 0 else '') + str(abs(index))
    lab += ')$'
    label.append(lab)

df = xu.io.XRDMLFile(os.path.join(datadir, "Polar Scan WZ 10-16.xrdml"))
s = df.scan

#chi = 90 - s['Psi']
chi = 90 - s['Chi']
phi = s['Phi']
INT = s['detector']

# create 2D arrays for the angles
CHI = chi[:, numpy.newaxis] * numpy.ones(INT.shape)
PHI = phi

#INT[INT < 300] = 1.0
#INT = xu.maplog(INT, 7, 1)

INT = xu.maplog(INT, 2, 0.8)

fig = plt.figure()
plt.clf()
# plt.title("(113) pole figure")
m = Basemap(boundinglat=-1., lon_0=180.0, resolution=None,
            projection='npstere')
X, Y = m(PHI, CHI)
ax = plt.subplot(111)
ax.set_frame_on(False)
CS = m.contourf(X, Y, INT, 100)
m.drawparallels(numpy.arange(0, 91, 30), labels=[1, 1, 1, 1],
                color='white', dashes=[2, 2])
m.drawmeridians(numpy.arange(0, 360, 30), labels=[1, 1, 1, 1],
                color='white', labelstyle='+/-', dashes=[2, 2],fontsize=8)

plt.suptitle('WZ 10-16',fontsize=15)
plt.tight_layout()


dphi = 62
dchi = -32
inpdir = xu.math.rotarb(GaP.Q(1, -1, 0), GaP.Q(1, 1, 1), dphi)
ndir = xu.math.rotarb(GaP.Q(1, 1, 1), inpdir, dchi)


#plt.savefig("./Pole_Figure_H06580_10-16_SiGe_111-Surface.png", dpi=600)